/**
 * Processing 4.x Compatibility Helper
 * 
 * This file contains workarounds for issues specific to Processing 4.x
 */

// NOTE: The isProcessing4 variable is now declared only in ParVaguesViz.pde
// We reference it directly without redeclaring it here

// Some helper functions for Processing 4 compatibility
void checkProcessingVersion() {
  // Check Processing version - this approach works with Processing 3 and 4
  try {
    // Get processing version using reflection to avoid errors
    java.lang.reflect.Field versionField = processing.core.PApplet.class.getDeclaredField("VERSION");
    versionField.setAccessible(true);
    String versionStr = (String) versionField.get(null);
    
    // Parse the version
    if (versionStr != null && versionStr.length() > 0) {
      String[] parts = versionStr.split("\\.");
      if (parts.length > 0) {
        int majorVersion = Integer.parseInt(parts[0]);
        isProcessing4 = (majorVersion >= 4);
        println("Detected Processing version: " + versionStr);
        println("Using Processing 4 compatibility: " + (isProcessing4 ? "yes" : "no"));
      }
    }
  } catch (Exception e) {
    // If we can't check the version, assume it's Processing 4 or higher
    println("Could not determine Processing version: " + e.getMessage());
    println("Assuming Processing 4 compatibility is needed");
    isProcessing4 = true;
  }
}

// Call this in your setup function near the beginning
void applyProcessing4Fixes() {
  if (isProcessing4) {
    // Fix to allow fullscreen toggle
    // In Processing 4, we use a different method for fullscreen
    frameRate(60); // Ensure decent frame rate
    
    // Fix for certain Linux/JDK combinations
    try {
      // Disable potential problem with X11 toolkit
      System.setProperty("awt.useSystemAAFontSettings", "on");
      System.setProperty("swing.aatext", "true");
    } catch (Exception e) {
      println("Warning: Could not set system properties: " + e.getMessage());
    }
  }
}

// Use this instead of the old fullscreen toggle
void toggleFullscreen() {
  if (isProcessing4) {
    // Processing 4.x way
    if (width != displayWidth || height != displayHeight) {
      surface.setSize(displayWidth, displayHeight);
      surface.setLocation(0, 0);
    } else {
      surface.setSize(1280, 720);
      surface.setLocation(displayWidth/2 - 640, displayHeight/2 - 360);
    }
  } else {
    // Processing 3.x way (original code)
    if (width == displayWidth && height == displayHeight) {
      surface.setSize(1280, 720);
    } else {
      surface.setSize(displayWidth, displayHeight);
    }
  }
}

// Update your keyPressed function to use this
void handleFullscreenToggle() {
  toggleFullscreen();
}
