module Sound.Tidal.ParVagues.Control (
  midiOn,
  midiOff,
  midiNo,
  midiDJF,
  midiG,
  midiG',
  midiGGlobal
) where

  -- import Sound.Tidal.Context
  -- import Sound.Tidal.Scales
  -- import Sound.Tidal.Chords

  -- Midi boolean buttons
  -- midiOn
  midiOn    ch    pat = someCyclesBy ch             pat
  midiOff   ch    pat = someCyclesBy (1 - ch)       pat
  midiNo    c1 c2 pat = someCyclesBy (1 - c1 - c2)  pat

  -- Parameterized DJF
  _LPF lMin lMax ch = (# lpf (min lMax ((range lMin ((lMax*2) - lMin) ch))))
  _HPF hMin hMax ch = (# hpf (max hMin (min hMax (range (hMin - hMax) (hMax - hMin) ch))))
  midiDJF   ch lMin lMax hMin hMax = (_LPF lMin lMax ch) . (_HPF hMin hMax ch)
  -- FIXME: Seems to cut some lows when lMin != 0

  -- Midi gain control (faders)
  midiGGlobal = "^77"
  _gainG ch     = (gain (midiGGlobal * ch)) -- gain Global
  midiG' ch l h = _gainG (range l h ch)     -- midiGain   control
  midiG  ch     = midiG' ch 0 1             -- midiGain   default
