# ParVaguesViz - Cyberpunk TidalCycles Visualizer

A cyberpunk-style visualization system for TidalCycles performances that works with your existing configuration without requiring any code changes.

## Features

- **Zero-configuration**: Works with standard TidalCycles/SuperDirt setup without modifying your patterns
- **Automatic track detection**: Different visual styles for different orbits (d1-d16)
- **Cyberpunk aesthetic**: Dark mode with neon colors, grids, and glitch effects
- **Audio-reactive**: Visualizations respond to the rhythm and intensity of your music
- **Customizable**: Multiple visualization styles and interactive controls

## Requirements

- [Processing](https://processing.org/) (v3.0+)
- [oscP5 library](https://sojamo.de/libraries/oscP5/)
- TidalCycles with SuperDirt running on the default port (57120)

## Installation

1. Download this repository to your `$WORK/Tidal/viz/` directory:

   ```bash
   mkdir -p $WORK/Tidal/viz
   cd $WORK/Tidal/viz
   # Copy all files here
   ```

2. Make sure you have Processing installed:

   ```bash
   # On Debian/Ubuntu
   sudo apt-get install processing
   
   # Or download from processing.org and install manually
   ```

3. Install the oscP5 library through the Processing IDE:
   - Open Processing
   - Go to Sketch > Import Library > Add Library
   - Search for "oscP5" and install it

4. Make the run script executable:

   ```bash
   chmod +x run_visualizer.sh
   ```

## Usage

1. Start TidalCycles and SuperDirt as usual without any modifications

2. Run the visualizer:

   ```bash
   cd $WORK/Tidal/viz
   ./run_visualizer.sh
   ```

3. Start creating music with TidalCycles! The visualizer will automatically detect and visualize your patterns.

## Controls

| Key | Action |
|-----|--------|
| D   | Toggle debug information display |
| H   | Toggle help screen |
| G   | Change grid style (standard, polar, hexagonal) |
| F   | Toggle fullscreen mode |
| R   | Reset all visualizations |

## How It Works

The visualizer listens for OSC messages from SuperDirt on port 57120. When TidalCycles sends messages to SuperDirt, the visualizer intercepts these messages and creates visual representations based on:

- **Orbit number**: Determines the track type and color (d1-d16)
- **Sound name**: Influences the visualization style
- **Gain**: Controls size and intensity of visual elements
- **Pan**: Determines horizontal position
- **CPS**: Affects timing and rhythm of the visualization

## Visualization Guide

Different tracks have distinct visual styles:

- **d1 (Orbit 0)**: Kicks - Impactful circular waves (Cyan)
- **d2 (Orbit 1)**: Snares - Particle explosions (Magenta)
- **d3 (Orbit 2)**: Hi-hats - Star-like shapes (Neon Green)
- **d4 (Orbit 3)**: Bass - Rippling ovals (Orange)
- **d5-d12**: Various instruments with appropriate visualizations

Sample-specific visualizations are also applied:

- **Keys/melodic**: Polygonal shapes
- **Breaks/jungle**: Chunky fragmented patterns
- **Voice samples**: Waveform-like visualizations
- **FX/risers**: Lightning and glow effects

## Customization

All visual elements can be customized by editing the Processing files. 
The main files are:

- **ParVaguesViz.pde**: Main sketch with initialization and OSC handling
- **TrackManager.pde**: Handles track visualization and sound events
- **Background.pde**: Creates the cyberpunk background
- **Grid.pde**: Manages the grid system with different styles
- **ParticleSystem.pde**: Particle effects for additional visual interest
- **GlitchEffect.pde**: Cyberpunk-style digital glitch effects

## Troubleshooting

- **No visualization**: Make sure SuperDirt is running on port 57120
- **Processing not found**: Set the correct path to processing-java in run_visualizer.sh
- **Missing oscP5 library**: Install it through the Processing IDE
- **Performance issues**: Lower the window size in ParVaguesViz.pde or reduce particle count

## License

This project is provided as-is for the ParVagues project.

## Acknowledgments

- TidalCycles and SuperDirt for the amazing live coding environment
- The Processing Foundation for their visualization tools
- The oscP5 library for OSC communication
